#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;
attribute vec2 inTexCoord0;
attribute vec4 inTexCoord1;

varying	vec3 lightVector, halfVector, lightVector2;
varying vec2 vTexCoord;
#else
in vec3 inVertex;
in vec3 inNormal;
in vec2 inTexCoord0;
in vec4 inTexCoord1;

out	vec3 lightVector, halfVector, lightVector2;
out vec2 vTexCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelViewMatrixInverse;

uniform vec3 lightSource1;
uniform vec3 lightSource1HV;
uniform vec3 lightSource2;
uniform vec3 lightSource2HV;

uniform mat4 scalerMatrix;
uniform mat4 texMatrix;

void main()
{
	vec3 vTangent = inTexCoord1.xyz;
	vec3 vBitangent = cross(inNormal, vTangent) * inTexCoord1.w;
	mat4 tmp = modelViewMatrixInverse * scalerMatrix;
	mat3 mvmi;
	mvmi[0] = tmp[0].xyz;
	mvmi[1] = tmp[1].xyz;
	mvmi[2] = tmp[2].xyz;

	vec3 lV = mvmi * lightSource1;
	vec3 hV = mvmi * normalize(lightSource1HV + lightSource2HV);
	vec3 l2V = mvmi * lightSource2;

	lightVector.x = dot(vTangent, lV);
	lightVector.y = dot(vBitangent, lV);
	lightVector.z = dot(inNormal, lV);

	lightVector2.x = dot(vTangent, l2V);
	lightVector2.y = dot(vBitangent, l2V);
	lightVector2.z = dot(inNormal, l2V);

	halfVector.x = dot(vTangent, hV);
	halfVector.y = dot(vBitangent, hV);
	halfVector.z = dot(inNormal, hV);
	
	vTexCoord = (texMatrix * vec4(inTexCoord0, 0, 0)).st;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
